/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.internal.core.github;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.github.IGithubManager;
import com.aptana.git.core.github.IGithubOrganization;
import com.aptana.git.core.github.IGithubRepository;
import com.aptana.git.core.github.IGithubUser;
import com.aptana.git.internal.core.github.GithubAPI;
import com.aptana.git.internal.core.github.GithubOrganization;
import com.aptana.git.internal.core.github.GithubRepository;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GithubUser
implements IGithubUser {
    private final String username;
    private final String password;

    public GithubUser(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public List<IGithubRepository> getRepos() throws CoreException {
        List result = (List)this.getAPI().get("user/repos");
        ArrayList<IGithubRepository> repoURLs = new ArrayList<IGithubRepository>(result.size());
        for (JSONObject repo : result) {
            repoURLs.add(this.createRepository(repo));
        }
        return repoURLs;
    }

    protected IGithubRepository createRepository(JSONObject repo) {
        return new GithubRepository(repo);
    }

    @Override
    public IGithubRepository getRepo(String repoName) throws CoreException {
        return this.getGithubManager().getRepo(this.username, repoName);
    }

    protected IGithubManager getGithubManager() {
        return GitPlugin.getDefault().getGithubManager();
    }

    @Override
    public Set<IGithubOrganization> getOrganizations() throws CoreException {
        List result = (List)this.getAPI().get("user/orgs");
        HashSet<IGithubOrganization> repoURLs = new HashSet<IGithubOrganization>(result.size());
        for (JSONObject repo : result) {
            repoURLs.add(this.createOrganization(repo));
        }
        return repoURLs;
    }

    protected IGithubOrganization createOrganization(JSONObject repo) {
        return new GithubOrganization(repo);
    }

    protected GithubAPI getAPI() {
        return new GithubAPI(this);
    }

    @Override
    public List<IGithubRepository> getAllRepos() throws CoreException {
        List<IGithubRepository> repos = this.getRepos();
        Set<IGithubOrganization> orgs = this.getOrganizations();
        if (!CollectionsUtil.isEmpty(orgs)) {
            for (IGithubOrganization org : orgs) {
                repos.addAll(org.getRepos());
            }
        }
        return repos;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IGithubUser)) {
            return false;
        }
        IGithubUser other = (IGithubUser)obj;
        if (this.password == null ? other.getPassword() != null : !this.password.equals(other.getPassword())) {
            return false;
        }
        return !(this.username == null ? other.getUsername() != null : !this.username.equals(other.getUsername()));
    }
}

